# fly.toml Configuration Reference

## Contents
- [Minimal Example](#minimal-example)
- [App Settings](#app-settings)
- [Build Configuration](#build-configuration)
- [HTTP Service](#http-service)
- [Services (Advanced)](#services-advanced)
- [Environment Variables](#environment-variables)
- [Deploy Settings](#deploy-settings)
- [VM Sizing](#vm-sizing)
- [Volumes](#volumes)
- [Health Checks](#health-checks)

## Minimal Example

```toml
app = "my-app"
primary_region = "ord"

[build]
  dockerfile = "Dockerfile"

[http_service]
  internal_port = 8080
  force_https = true
  auto_stop_machines = "stop"
  auto_start_machines = true
```

## App Settings

```toml
app = "my-app-name"           # Required: app name
primary_region = "ord"        # Required: default region for new machines
```

**Regions:** Run `fly platform regions` for full list. Common: `ord` (Chicago), `iad` (Virginia), `lax` (LA), `fra` (Frankfurt), `sin` (Singapore).

## Build Configuration

**Dockerfile (most common):**
```toml
[build]
  dockerfile = "Dockerfile"     # Default: Dockerfile in root
  # dockerfile = "deploy/Dockerfile"  # Custom path
```

**Build arguments:**
```toml
[build.args]
  NODE_ENV = "production"
```

**Pre-built image:**
```toml
[build]
  image = "nginx:alpine"
```

**Buildpacks (no Dockerfile):**
```toml
[build]
  builder = "paketobuildpacks/builder:base"
```

## HTTP Service

For apps serving HTTP/HTTPS on ports 80/443:

```toml
[http_service]
  internal_port = 8080          # Port your app listens on
  force_https = true            # Redirect HTTP → HTTPS
  auto_stop_machines = "stop"   # Stop idle machines (or "off", "suspend")
  auto_start_machines = true    # Start on incoming request
  min_machines_running = 0      # Keep N machines always running

[http_service.concurrency]
  type = "requests"             # or "connections"
  soft_limit = 200              # Start routing elsewhere
  hard_limit = 250              # Stop accepting
```

**auto_stop_machines options:**
- `"off"` — Never stop (always running, higher cost)
- `"stop"` — Stop after idle period (cold starts on next request)
- `"suspend"` — Suspend (faster wake than stop)

## Services (Advanced)

For non-HTTP protocols or multiple ports:

```toml
[[services]]
  internal_port = 5432
  protocol = "tcp"

[[services.ports]]
  port = 5432
  handlers = ["tls"]
```

## Environment Variables

Non-sensitive values (secrets go via `fly secrets set`):

```toml
[env]
  NODE_ENV = "production"
  LOG_LEVEL = "info"
  PORT = "8080"
```

## Deploy Settings

```toml
[deploy]
  release_command = "npm run db:migrate"  # Run before deploy
  strategy = "rolling"                    # rolling|bluegreen|canary|immediate
```

**Release command notes:**
- Runs in temporary machine with no volumes
- 5 minute timeout (configurable)
- Non-zero exit stops deployment
- Great for database migrations

```toml
[deploy]
  release_command = "python manage.py migrate"
  release_command_timeout = "10m"
```

## VM Sizing

```toml
[vm]
  size = "shared-cpu-1x"    # Default
  memory = "512mb"          # Override memory
```

**Sizes:**
- `shared-cpu-1x` — 1 shared CPU, 256MB (default)
- `shared-cpu-2x` — 2 shared CPU, 512MB
- `shared-cpu-4x` — 4 shared CPU, 1GB
- `performance-1x` — 1 dedicated CPU, 2GB
- `performance-2x` — 2 dedicated CPU, 4GB

Scale via CLI: `fly scale vm shared-cpu-2x`

## Volumes

Persistent storage:

```toml
[mounts]
  source = "myapp_data"
  destination = "/data"
  initial_size = "1gb"
```

Create volume first: `fly volumes create myapp_data --size 1 --region ord`

## Health Checks

HTTP health check:

```toml
[[http_service.checks]]
  grace_period = "10s"      # Wait after start before checking
  interval = "30s"          # Time between checks
  method = "GET"
  path = "/health"          # Health endpoint
  timeout = "5s"            # Max response time
```

**Common issues:**
- `grace_period` too short — App hasn't started yet
- Wrong `path` — Returns 404, fails health check
- `internal_port` mismatch — App listens on different port
